/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.panel.pa.manual;

import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.DateItemDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TimeItemDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ErrorBean
extends PanelBean {
    private static final String TABLE_NAME = "ErrorTable";
    private static final String TRACE_MASKT = "XPAXMEBT";
    private static final String TRACE_MASKF = "XPAXMEBF";
    private static final String TRACE_MASKD = "XPAXMEBD";
    private String m_sSystemNameOutput;
    private String m_sChannelPathOutput = null;
    private String m_sInterfaceOutput = null;
    private ItemDescriptor[] m_idErrorTable;
    private ColumnDescriptor[] m_cdErrorTableStructure;
    private int[] m_iErrorTableSelection;
    private List content = new ArrayList();

    public ErrorBean(String systemName) {
        this.m_sSystemNameOutput = systemName;
    }

    public void setChannelPath(String path) {
        this.m_sChannelPathOutput = path;
    }

    public void setInterfaceLocation(String location) {
        this.m_sInterfaceOutput = location;
    }

    public void addDataRow(Date date, LocalizableText description) {
        Trace.trace(TRACE_MASKT, "{ErrorBean} addDataRow(" + date + "," + description + ").");
        this.content.add(new ContentElement(date, description));
    }

    public void prepare() {
        this.loadTableData();
        if (this.m_sInterfaceOutput == null) {
            this.userTaskManager.setShown(this.getMountPrefix() + "InterfaceOutput", false);
        }
        if (this.m_sChannelPathOutput == null) {
            this.userTaskManager.setShown(this.getMountPrefix() + "ChannelPathOutput", false);
        }
    }

    private void loadTableData() {
        Trace.trace(TRACE_MASKT, "{ErrorBean} loadTableData()");
        Iterator iterator = this.content.iterator();
        int row = 0;
        while (iterator.hasNext()) {
            ContentElement ce = (ContentElement)iterator.next();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(ce.date);
            this.userTaskManager.addRow(TABLE_NAME, row, new ItemDescriptor[]{new DateItemDescriptor("date." + row, calendar), new TimeItemDescriptor("time." + row, calendar), new ItemDescriptor("description." + row, ce.description.toString())});
            ++row;
        }
    }

    public void panelAction(TaskActionEvent event) {
        if (event.getActionCommand().equals("CANCEL")) {
            this.dispose();
        } else {
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("event", event);
            request.setData("command", event.getActionCommand());
            int[] selectedRows = this.userTaskManager.getSelectedRows(TABLE_NAME);
            if (selectedRows.length > 0) {
                request.setData("selection", new Integer(selectedRows[0]));
            } else {
                request.setData("selection", new Integer(0));
            }
            this.postTaskletRequest(request);
        }
    }

    public String getSystemNameOutput() {
        return this.m_sSystemNameOutput;
    }

    public void setSystemNameOutput(String s) throws IllegalUserDataException {
        this.m_sSystemNameOutput = s;
    }

    public String getChannelPathOutput() {
        return this.m_sChannelPathOutput;
    }

    public void setChannelPathOutput(String s) throws IllegalUserDataException {
        this.m_sChannelPathOutput = s;
    }

    public String getInterfaceOutput() {
        return this.m_sInterfaceOutput;
    }

    public void setInterfaceOutput(String s) throws IllegalUserDataException {
        this.m_sInterfaceOutput = s;
    }

    public ColumnDescriptor[] getErrorTableRowStructure() {
        return this.m_cdErrorTableStructure;
    }

    public int getErrorTableRowStatus() {
        return 3;
    }

    public int getErrorTableRowCount() {
        return 0;
    }

    public ItemDescriptor[] getErrorTableRowAt(int index) {
        return this.m_idErrorTable;
    }

    public void setErrorTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idErrorTable = items;
    }

    public int[] getErrorTableSelection() {
        return this.m_iErrorTableSelection;
    }

    public void setErrorTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iErrorTableSelection = selected;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void load() {
    }

    public class ContentElement
    implements Serializable {
        public Date date;
        public LocalizableText description;

        ContentElement(Date date, LocalizableText description) {
            this.date = date;
            this.description = description;
        }
    }
}

